a, n, k = [int(i) for i in input().split()]

# use a recursive approach using Euler's theorem
def modulartetration(a, n, twos, fivs):
    # keep track of power of 2 and 5 of modulus
    # to quickly compute phi(mod)
    mod = (2 ** twos) * (5 ** fivs)
    if n == 1: # base case
        return a % mod
    else:      # recursive case
        # reduce using Euler's theorem; compute phi(mod)
        # as factors can only ever be 2 and 5, always gcd(a,mod) = 1
        phitwos = 0
        phifivs = 0
        if fivs > 0:
            phifivs += fivs - 1
            phitwos += 2
        if twos > 0:
            phitwos += twos - 1
        # Reduce complexity using Euler's theorem
        powmod = modulartetration(a, n - 1, phitwos, phifivs)
        # Need to use modular exponentiation, else timelimit
        return pow(a, powmod, mod)

# pad leading zeroes
def padzeroes(x, k):
    digits = str(x)
    pad = k - len(digits)
    return '0' * pad + digits
        
# start recursion for answer and pad enough zeroes
print(padzeroes(modulartetration(a, n, k, k),k))
